<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Track extends Model 
{

    protected $table = 'tracks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function event()
    {
        return $this->belongsTo('Event', 'event_id');
    }

    public function races()
    {
        return $this->hasMany('Race');
    }

}